/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import net.proteanit.sql.DbUtils;

public class Room
extends JFrame {
    Connection con = null;
    ResultSet rs = null;
    PreparedStatement pst = null;
    private JTable Room_table;
    private JButton btnDelete;
    private JButton btnGetData;
    private JButton btnNew;
    private JButton btnSave;
    private JButton btnUpdate;
    private JComboBox cmbRoomType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextField txtRoomCharges;
    private JTextField txtRoomNo;

    public Room() {
        this.initComponents();
        this.con = Connect.ConnectDB();
        this.Get_Data();
        this.setLocationRelativeTo(null);
    }

    private void Reset() {
        this.txtRoomNo.setText("");
        this.txtRoomCharges.setText("");
        this.cmbRoomType.setSelectedIndex(-1);
        this.btnSave.setEnabled(true);
        this.btnDelete.setEnabled(false);
        this.btnUpdate.setEnabled(false);
        this.txtRoomNo.requestDefaultFocus();
        this.Get_Data();
    }

    private void Get_Data() {
        String sql = "select RoomNo as 'Room No.',RoomType as 'Room Type', RoomCharges as 'Room Charges',RoomStatus as 'Room Status' from Room";
        try {
            this.pst = this.con.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            this.Room_table.setModel(DbUtils.resultSetToTableModel((ResultSet)this.rs));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtRoomNo = new JTextField();
        this.cmbRoomType = new JComboBox();
        this.txtRoomCharges = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPanel3 = new JPanel();
        this.btnNew = new JButton();
        this.btnSave = new JButton();
        this.btnUpdate = new JButton();
        this.btnDelete = new JButton();
        this.btnGetData = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.Room_table = new JTable();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Room Info"));
        this.jLabel1.setText("Room No.");
        this.jLabel2.setText("Room Type");
        this.jLabel3.setText("Room Charges");
        this.cmbRoomType.setModel(new DefaultComboBoxModel<String>(new String[]{"General", "Deluxe"}));
        this.cmbRoomType.setSelectedIndex(-1);
        this.txtRoomCharges.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                Room.this.txtRoomChargesKeyTyped(evt);
            }
        });
        this.jLabel4.setText("(Per day)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel4)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING)).addGap(41, 41, 41).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtRoomNo).addComponent(this.cmbRoomType, 0, 84, Short.MAX_VALUE).addComponent(this.txtRoomCharges)))).addContainerGap(31, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtRoomNo, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.cmbRoomType, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txtRoomCharges, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, 14, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(""));
        this.btnNew.setFont(new Font("Tahoma", 0, 10));
        this.btnNew.setText("New");
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Room.this.btnNewActionPerformed(evt);
            }
        });
        this.btnSave.setFont(new Font("Tahoma", 0, 10));
        this.btnSave.setText("Save");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Room.this.btnSaveActionPerformed(evt);
            }
        });
        this.btnUpdate.setFont(new Font("Tahoma", 0, 10));
        this.btnUpdate.setText("Update");
        this.btnUpdate.setEnabled(false);
        this.btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Room.this.btnUpdateActionPerformed(evt);
            }
        });
        this.btnDelete.setFont(new Font("Tahoma", 0, 10));
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Room.this.btnDeleteActionPerformed(evt);
            }
        });
        this.btnGetData.setFont(new Font("Tahoma", 0, 10));
        this.btnGetData.setText("Get Data");
        this.btnGetData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Room.this.btnGetDataActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnNew, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.btnGetData).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.btnSave, -1, -1, Short.MAX_VALUE).addComponent(this.btnUpdate, -1, -1, Short.MAX_VALUE).addComponent(this.btnDelete, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.btnNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGetData).addContainerGap(-1, Short.MAX_VALUE)));
        this.Room_table.setFont(new Font("Palatino Linotype", 1, 12));
        this.Room_table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Room No.", "Room Type", "Room Charges", "Room Status"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, true, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.Room_table.getTableHeader().setReorderingAllowed(false);
        this.Room_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Room.this.Room_tableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.Room_table);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(31, 31, 31).addComponent(this.jPanel3, -2, -1, -2).addGap(0, 53, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 237, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void txtRoomChargesKeyTyped(KeyEvent evt) {
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        this.Reset();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        try {
            this.con = Connect.ConnectDB();
            if (this.txtRoomNo.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "Please enter room no.", "Error", 0);
                return;
            }
            if (this.cmbRoomType.getSelectedItem().equals("")) {
                JOptionPane.showMessageDialog(this, "Please select room type", "Error", 0);
                return;
            }
            if (this.txtRoomCharges.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "Please enter room Charges", "Error", 0);
                return;
            }
            Statement stmt = this.con.createStatement();
            String sql1 = "Select RoomNo from Room where RoomNo= '" + this.txtRoomNo.getText() + "'";
            this.rs = stmt.executeQuery(sql1);
            if (this.rs.next()) {
                JOptionPane.showMessageDialog(this, "Room No. already exists", "Error", 0);
                this.txtRoomNo.setText("");
                this.txtRoomNo.requestDefaultFocus();
                return;
            }
            String sql = "insert into Room(RoomNo,RoomType,RoomCharges,RoomStatus)values('" + this.txtRoomNo.getText() + "','" + this.cmbRoomType.getSelectedItem() + "'," + this.txtRoomCharges.getText() + ",'Vacant')";
            this.pst = this.con.prepareStatement(sql);
            this.pst.execute();
            JOptionPane.showMessageDialog(this, "Successfully saved", "Room Record", 1);
            this.btnSave.setEnabled(false);
            this.Get_Data();
        }
        catch (HeadlessException | SQLException ex) {
            JOptionPane.showMessageDialog(this, ex);
        }
    }

    private void btnUpdateActionPerformed(ActionEvent evt) {
        try {
            this.con = Connect.ConnectDB();
            String sql = "update Room set Roomtype='" + this.cmbRoomType.getSelectedItem() + "',RoomCharges=" + this.txtRoomCharges.getText() + " where RoomNo='" + this.txtRoomNo.getText() + "'";
            this.pst = this.con.prepareStatement(sql);
            this.pst.execute();
            JOptionPane.showMessageDialog(this, "Successfully updated", "Room Record", 1);
            this.btnUpdate.setEnabled(false);
            this.Get_Data();
        }
        catch (HeadlessException | SQLException ex) {
            JOptionPane.showMessageDialog(this, ex);
        }
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        try {
            int P = JOptionPane.showConfirmDialog(null, " Are you sure want to delete ?", "Confirmation", 0);
            if (P == 0) {
                this.con = Connect.ConnectDB();
                String sql = "delete from Room where RoomNo = '" + this.txtRoomNo.getText() + "'";
                this.pst = this.con.prepareStatement(sql);
                this.pst.execute();
                JOptionPane.showMessageDialog(this, "Successfully deleted", "Record", 1);
                this.Reset();
            }
        }
        catch (HeadlessException | SQLException ex) {
            JOptionPane.showMessageDialog(this, ex);
        }
    }

    private void btnGetDataActionPerformed(ActionEvent evt) {
        this.Get_Data();
    }

    private void Room_tableMouseClicked(MouseEvent evt) {
        try {
            this.con = Connect.ConnectDB();
            int row = this.Room_table.getSelectedRow();
            String table_click = this.Room_table.getModel().getValueAt(row, 0).toString();
            String sql = "select * from Room where RoomNo = '" + table_click + "'";
            this.pst = this.con.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            if (this.rs.next()) {
                String add1 = this.rs.getString("RoomNo");
                this.txtRoomNo.setText(add1);
                String add2 = this.rs.getString("RoomType");
                this.cmbRoomType.setSelectedItem(add2);
                int add3 = this.rs.getInt("RoomCharges");
                String add4 = Integer.toString(add3);
                this.txtRoomCharges.setText(add4);
                this.btnUpdate.setEnabled(true);
                this.btnDelete.setEnabled(true);
                this.btnSave.setEnabled(false);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Room.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Room.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Room.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Room.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Room().setVisible(true);
            }
        });
    }
}

